package gov.va.vinci.dart.db.impl;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.Activity;
import gov.va.vinci.dart.db.ActivityDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class ActivityDAOImpl extends HibernateDAO implements ActivityDAO {

	public void save(final Activity activity) {
		throw new IllegalStateException("Activity instances should be saved through their concrete class DAOs, not through ActivityDAO");
	}
	
	public Activity findById(final int activityId) {
		Query q = createQuery("from Activity where id=:aid");
		q.setParameter("aid", activityId);
		return (Activity)q.getSingleResult();
	}

}
